// Mirror Copy.js
//
// v.20091015
//
// toDo: optimizing code. :p
//
// v.20070730: extended for copy polygon object.
// v.20091015: fix bug for 5.0
// v.20091208: name conversion added. Left <-> Right, Top <-> Bottom, .L <-> .R, _L <-> _R, .T <-> .B, _T <-> _B
// v.20091209: add error check
// v.20100121: remove prototype functions
// v.20100209: bug fixed, add "none" option.
//
// Description: copy objects.
// Usage: Place this into ~/Library/Application Support/Cheetah3D/scripts/Tool folder. restart Cheetah3D, then select from Tools -> Script -> Tool Script

/*
Vec2D.prototype.toString = function() {
	return this.u.toFixed(6) + ' ' + this.v.toFixed(6);
}
Vec3D.prototype.toString = function() {
	return this.x.toFixed(6) + ' ' + this.y.toFixed(6) + ' ' + this.z.toFixed(6);
}
Vec4D.prototype.toString = function() {
	return this.x.toFixed(6) + ' ' + this.y.toFixed(6) + ' ' + this.z.toFixed(6) + ' ' + this.w.toFixed(6);
}
*/

var Mirror_Plane = 0;

var pList = new Array;
var jType = true;
var jMode = true;
var jColor = true;
var jTag = true;

var nConvert = true;

function buildUI(tool) {
    tool.addParameterSeparator("Mirror Copy");
    tool.addParameterSelector("mirror plane",["x","y","z","none"],false,false);
    
    tool.addParameterBool("name convert", 1, 0, 1, true, true);
    
    tool.addParameterSeparator("Bone Parameters");
    
    tool.addParameterBool("joint type",1,0,1,true,true);
    tool.addParameterBool("joint display mode",1,0,1,true,true);
    tool.addParameterBool("joint color",1,0,1,true,true);
    
    tool.addParameterSeparator("Tag");
    tool.addParameterBool("tag copy",1,0,1,true,true);
    
    tool.addParameterSeparator("Object Copy");
    tool.addParameterButton("copy","copy","Copy");
    
    tool.addParameterSeparator("Parameter Copy");
    tool.addParameterButton("parameter copy","copy","pCopy");
    tool.addParameterButton("parameter paste","paste","pPaste");
    
}

function Copy(tool) {
    var doc = tool.document();
    var obj = doc.selectedObject();
    
    Mirror_Plane = parseInt(tool.getParameter("mirror plane"));
    
    nConvert = tool.getParameter("name convert");
    jType = tool.getParameter("joint type");
    jMode = tool.getParameter("joint display mode");
    jColor = tool.getParameter("joint color");
    jTag = tool.getParameter("tag copy");
    
    var list = new Array;
    var parentObj = obj.owner();
    
    list = StoreChild(0, obj);
    
    CopyChild(doc, parentObj, list);
}

function pCopy(tool) {
    var doc = tool.document();
    var obj = doc.selectedObject();
    
    Mirror_Plane = parseInt(tool.getParameter("mirror plane"));
    
    jType = tool.getParameter("joint type");
    jMode = tool.getParameter("joint display mode");
    jColor = tool.getParameter("joint color");
    jTag = tool.getParameter("tag copy");
    
    pList = new Array();
    
    pList = StoreChild(0, obj);
}

function pPaste(tool) {
    var doc = tool.document();
    var obj = doc.selectedObject();
    
    Mirror_Plane = parseInt(tool.getParameter("mirror plane"));
    
    jType = tool.getParameter("joint type");
    jMode = tool.getParameter("joint display mode");
    jColor = tool.getParameter("joint color");
    jTag = tool.getParameter("tag copy");
    
    if (pList.length > 0) {
        pPasteChild(obj, pList);
    }
}

function StoreChild(iter, obj) {
    var childCount = obj.childCount();
    var list = new Array(iter, obj, new Array);
    for (var i = 0; i < childCount;i++) {
        var child = obj.childAtIndex(i);
        var childList = StoreChild(iter+1, child);
        list[2].push(childList);
    }
    return list;
}

function getPos(vec) {
    switch(Mirror_Plane) {
        case 0:
            vec.x *= -1;
            break;
        case 1:
            vec.y *= -1;
            break;
        case 2:
            vec.z *= -1;
            break;
    }
    return vec;
}

function getRot(vec) { // HPB
    switch(Mirror_Plane) {
        case 0:
            vec.x *= -1;
            vec.z *= -1;
            break;
        case 1:
            vec.y *= -1;
            vec.z *= -1;
            break;
        case 2:
            vec.x *= -1;
            vec.y *= -1;
            break;
    }
    return vec;
}

function CopyCore(core, cCore) {
    var i, j;
    var polyCount = cCore.polygonCount();
    var vertexCount = cCore.vertexCount();
    
    for (i = 0;i < vertexCount;i++) {
        var vert = getPos(cCore.vertex(i));
        core.addVertex(false, vert);
    }
    for (i = 0;i < polyCount;i++) {
        var size = cCore.polygonSize(i);
        var verts = new Array;
        var uvs = new Array;
        for (j = 0;j < size;j++) {
            verts[j] = cCore.vertexIndex(i, j);
            var uv = cCore.uvCoord(i,j);
            uvs[j] = new Vec2D(uv.x, uv.y);
        }
        core.addIndexPolygon(size, verts, uvs);
        core.flipWinding(i);
    }
}

var pattern = [ ["Left","Right"], ["Right","Left"], ["LEFT","RIGHT"], ["RIGHT","LEFT"], ["left","right"], ["right","left"],
				[/([\._]+)L$/,"$1R"],[/([\._]+)R$/,"$1L"],[/^L([\._]+)/,"R$1"],[/^R([\._]+)/,"L$1"],
				[/([\._]+)l$/,"$1r"],[/([\._]+)r$/,"$1l"],[/^l([\._]+)/,"r$1"],[/^r([\._]+)/,"l$1"],
				["Top","Bottom"], ["Bottom","Top"], ["TOP","BOTTOM"], ["BOTTOM","TOP"], ["top","bottom"], ["bottom","top"],
				[/([\._]+)T$/,"$1B"],[/([\._]+)B$/,"$1T"],[/^T([\._]+)/,"B$1"],[/^B([\._]+)/,"T$1"],
				[/([\._]+)t$/,"$1b"],[/([\._]+)b$/,"$1t"],[/^t([\._]+)/,"b$1"],[/^b([\._]+)/,"t$1"]
			  ];

var skipParams = [ "name", "position", "rotation", "scale", "pivot", "shear", "jointType", "displayMode", "jointColor" ];

var tag_skipParams = [ ];

function CopyChild(doc, obj, list) {
    //var count = list.length;
    var name = list[1].getParameter("name");
    var pos = list[1].getParameter("position");
    var rot = list[1].getParameter("rotation");
    var scale = list[1].getParameter("scale");
    // 
    var pivot = list[1].getParameter("pivot");
    var shear = list[1].getParameter("shear");
    
    pos = getPos(pos);
    pivot = getPos(pivot);
    rot = getRot(rot);
	
    var obj_copied = doc.addObject(list[1].type());
    // for polygon object
    if (list[1].type() == POLYGONOBJ) {
    	CopyCore(obj_copied.core(), list[1].core());
    }
    //
	var name_copied = false;
    if (nConvert) {
	    var p_len = pattern.length;
	    for (var i = 0;i < p_len;i++) {
	    	if ( name.match(pattern[i][0]) ) {
	    		name_copied = name.replace(pattern[i][0], pattern[i][1]);
	    		break;
	    	}
	    }
	}
    if (!name_copied) name_copied = name+"_copy";
    //
    obj_copied.setParameter("name",name_copied);
    obj_copied.setParameter("position",pos);
    obj_copied.setParameter("rotation",rot);
    obj_copied.setParameter("scale",scale);
    //
    obj_copied.setParameter("pivot",pivot);
    obj_copied.setParameter("shear",shear);
    
    // for bone object
    
    if (list[1].type() == 45) { // BONE OBJECT
        if (jType) obj_copied.setParameter("jointType", list[1].getParameter("jointType"));
        if (jMode) obj_copied.setParameter("displayMode", list[1].getParameter("displayMode"));
        if (jColor) obj_copied.setParameter("jointColor", list[1].getParameter("jointColor"));
    }
    
    // copy other parameters
    
    var info = list[1].parameterInfo();
    
    for (var i = 0; i < info.length; i++) {
    	if (skipParams.indexOf( info[i][0] ) < 0 && info[i][1] != "Link" ) {
    		obj_copied.setParameter( info[i][0], list[1].getParameter(info[i][0]) );
    	}
    }
    
    if (jTag) {
        var tagCount = list[1].tagCount();
        for (var i = 0;i < tagCount;i++) {
            var tTag = list[1].tagAtIndex(i);
            if (tTag.type() > 104) { // not object tag, not mode tag.
                var cTag = obj_copied.addTagOfType(tTag.type());
                var tagInfo = tTag.parameterInfo();
                if (tTag.type() == 120) {
                    var constraintRotMin = new Vec3D();
                    var constraintRotMax = new Vec3D();
                    for (var j = 0;j < tagInfo.length;j++) {
                        switch(tagInfo[j][0]) {
                            case "constraintRotH":
                                var constraint = tTag.getParameter(tagInfo[j][0]);
                                constraintRotMin.x = constraint.u;
                                constraintRotMax.x = constraint.v;
                                break;
                            case "constraintRotP":
                                var constraint = tTag.getParameter(tagInfo[j][0]);
                                constraintRotMin.y = constraint.u;
                                constraintRotMax.y = constraint.v;
                                break;
                            case "constraintRotB":
                                var constraint = tTag.getParameter(tagInfo[j][0]);
                                constraintRotMin.z = constraint.u;
                                constraintRotMax.z = constraint.v;
                                break;
                            default:
                                cTag.setParameter(tagInfo[j][0], tTag.getParameter(tagInfo[j][0]));
                        }
                    }
                    constraintRotMin = getRot(constraintRotMin);
                    constraintRotMax = getRot(constraintRotMax);
                    var rh = new Vec2D(Math.min(constraintRotMin.x, constraintRotMax.x),
                                        Math.max(constraintRotMin.x, constraintRotMax.x));
                    var rp = new Vec2D(Math.min(constraintRotMin.y, constraintRotMax.y),
                                        Math.max(constraintRotMin.y, constraintRotMax.y));
                    var rb = new Vec2D(Math.min(constraintRotMin.z, constraintRotMax.z),
                                        Math.max(constraintRotMin.z, constraintRotMax.z));
                    cTag.setParameter("constraintRotH", rh);
                    cTag.setParameter("constraintRotP", rp);
                    cTag.setParameter("constraintRotB", rb);
                } else {
                    for (var j = 0;j < tagInfo.length;j++) {
                    	if ( tag_skipParams.indexOf( tagInfo[j][0] ) < 0 && tagInfo[j][1] != "Link" ) {
                        	cTag.setParameter(tagInfo[j][0], tTag.getParameter(tagInfo[j][0]));
                        }
                    }
                }
            }
        }
    }
    
    var count = list[2].length;
    for (var i = 0;i < count;i++) {
        CopyChild(doc, obj_copied, list[2][i]);
    }
    obj.addChildAtIndex(obj_copied, 0);
}

function pPasteChild(obj, list) {
	
	if (list && obj.type() == list[1].type()) {
	    var pos = list[1].getParameter("position");
	    var rot = list[1].getParameter("rotation");
	    var scale = list[1].getParameter("scale");
	    //
	    var pivot = list[1].getParameter("pivot");
	    var shear = list[1].getParameter("shear");
	    
	    pos = getPos(pos);
	    rot = getRot(rot);
	    pivot = getPos(pivot);
	    
	    obj.setParameter("position",pos);
	    obj.setParameter("rotation",rot);
	    obj.setParameter("scale",scale);
	    obj.setParameter("pivot",pivot);
	    obj.setParameter("shear",shear);
	    
	    if (list[1].type() == 45) { // BONE OBJECT
	        if (jType)  obj.setParameter( "jointType", list[1].getParameter("jointType") );
	        if (jMode)  obj.setParameter( "displayMode", list[1].getParameter("displayMode") );
	        if (jColor) obj.setParameter( "jointColor", list[1].getParameter("jointColor") );
	    }
	    
	    // paste other parameters
	    
	    var info = list[1].parameterInfo();
	    
	    for (var i = 0;i < info.length;i++) {
	    	if (skipParams.indexOf( info[i][0] ) < 0 && info[i][1] != "Link") {
	    		obj.setParameter( info[i][0], list[1].getParameter( info[i][0] ) );
	    	}
	    }
	    
	    if (jTag) {
	        var tagCount = list[1].tagCount();
	        var tagCount_o = obj.tagCount();
	        if (tagCount == tagCount_o) { // must be same tag count
	            for (var i = 0;i < tagCount;i++) {
	                var tTag = list[1].tagAtIndex(i); // from tag
	                var oTag = obj.tagAtIndex(i); // to tag
	                if (oTag.type() != 104 && tTag.type() == oTag.type()) { // must be same tag.
	                    var tagInfo = tTag.parameterInfo();
	                    if (tTag.type() == 120) {
	                        var constraintRotMin = new Vec3D();
	                        var constraintRotMax = new Vec3D();
	                        for (var j = 0;j < tagInfo.length;j++) {
	                            switch(tagInfo[j][0]) {
	                                case "constraintRotH":
	                                    var constraint = tTag.getParameter(tagInfo[j][0]);
	                                    constraintRotMin.x = constraint.u;
	                                    constraintRotMax.x = constraint.v;
	                                    break;
	                                case "constraintRotP":
	                                    var constraint = tTag.getParameter(tagInfo[j][0]);
	                                    constraintRotMin.y = constraint.u;
	                                    constraintRotMax.y = constraint.v;
	                                    break;
	                                case "constraintRotB":
	                                    var constraint = tTag.getParameter(tagInfo[j][0]);
	                                    constraintRotMin.z = constraint.u;
	                                    constraintRotMax.z = constraint.v;
	                                    break;
	                                default:
	                                    oTag.setParameter(tagInfo[j][0], tTag.getParameter(tagInfo[j][0]));
	                            }
	                        }
	                        constraintRotMin = getRot(constraintRotMin);
	                        constraintRotMax = getRot(constraintRotMax);
	                        var rh = new Vec2D(Math.min(constraintRotMin.x, constraintRotMax.x),
	                                            Math.max(constraintRotMin.x, constraintRotMax.x));
	                        var rp = new Vec2D(Math.min(constraintRotMin.y, constraintRotMax.y),
	                                            Math.max(constraintRotMin.y, constraintRotMax.y));
	                        var rb = new Vec2D(Math.min(constraintRotMin.z, constraintRotMax.z),
	                                            Math.max(constraintRotMin.z, constraintRotMax.z));
	                        oTag.setParameter("constraintRotH", rh);
	                        oTag.setParameter("constraintRotP", rp);
	                        oTag.setParameter("constraintRotB", rb);
	                    } else {
	                        for (var j = 0;j < tagInfo.length;j++) {
                    		if ( tag_skipParams.indexOf( tagInfo[j][0] ) < 0 && tagInfo[j][1] != "Link") {
	                            	oTag.setParameter(tagInfo[j][0], tTag.getParameter(tagInfo[j][0]));
	                          	}
	                        }
	                    }
	                }
	            }
	        }
	    }
	}
	
    var count = obj.childCount();
    for (var i = 0;i < count;i++) {
        pPasteChild(obj.childAtIndex(i), list[2][i]);
    }
}

